clear all
close all
clc


%% parameters 
WE = 2.115
theta = 1;
epsilon = 1e-2;
N = 9;
p = epsilon*(2*rand(N,1)-1);
p = 0.2-mean(p)+p; %force the mean to be exactly p, guarantees identical attractor as the homogeneous case
a = 5; 
tau1 = 1;
tau2 = 5;
T = 1*10^3; 

%% connectivity 
WEE = zeros(N,N);
for i = 1:N
WEE(i,mod(i-2,N)+1)=WE;
end 
    

%% 
options = odeset('AbsTol',1e-14,'RelTol',1e-14);
int = rand(3*N,1);
tic
[t,y] = ode45(@(t,y) WC(WEE,tau1,tau2,p,a,theta,N,y),0:0.1:T,int,options); 
toc
%%

figure(1)
plot(t,y(:,1:N))
xlabel('Time')
ylabel('E(t)')
